package treeNAlgo;
import treeN.*;
import extvisitor.*;

/**
 * 
 * Uses lambda-based extended visitors
 */
public class ToStringAlgo2 extends ATreeNAlgo<Object, String, Object> {
  public static ToStringAlgo2 Singleton = new ToStringAlgo2();
  
  private ToStringAlgo2() {  
    super( new IExtVisitorCmd<String, Integer, Object, TreeN<Object>>(){
      public String apply(Integer index, TreeN<Object> host, Object... params) {
        String sData= "", sTrees="";
        for(int i = 0;i<index;i++) {
          sData += host.getDat(i)+" ";
          sTrees += host.getChild(i).execute(toStringHelp,"|  ")+"\n";
        }
        sTrees += host.getChild(index).execute(toStringHelp,"   ").toString();
        return sData +"\n"+sTrees;
      }
    });
    
    setCmd(0,new IExtVisitorCmd<String, Integer, Object, TreeN<Object>>(){
      public String apply(Integer index, TreeN<Object> host, Object... params) {
        return "[ ]";
      }
    }); 
  }
  
  //----------- helper algo --------------------------------------------------
  final private static ITreeNAlgo<Object, String, String> toStringHelp = 
    // Default command
    new ATreeNAlgo<Object, String, String>(new IExtVisitorCmd<String, Integer, String, TreeN<Object>>(){
    public String apply(Integer index, TreeN<Object> host, String... prefix) {
      String sData= "", sTrees="";
      for(int i = 0;i<index;i++) {
        sData += host.getDat(i)+" ";
        sTrees += prefix[0]
          + host.getChild(i).execute(toStringHelp,
                                     prefix[0]+"|  ")+"\n";
      }
      sTrees += prefix[0] 
        + host.getChild(index).execute(toStringHelp, prefix[0]+"   ");
      return "|_ "+sData +"\n"+sTrees;
    }
  }) {
    
    // Initializer block
    {
      setCmd(0,new IExtVisitorCmd<String, Integer, String, TreeN<Object>>(){
        public String apply(Integer index, TreeN<Object> host, String... prefix) {
          return "|_[ ]";
        }
      });  
    }    
  };
}
